DROP PROCEDURE IF EXISTS sp_insertUpdateOrdenCompra;

delimiter $
CREATE DEFINER=`root`@`localhost` PROCEDURE sp_insertUpdateOrdenCompra(IN p_idOrdenCompra INT, IN p_idCotizacion INT, IN p_idOrdenMantenimiento INT, IN `p_idOrdenServicio` INT, IN `p_idProveedor` INT, IN `p_codCotizacion` VARCHAR(50), IN `p_serieDocumento` VARCHAR(50), IN `p_numeroDocumento` VARCHAR(50), IN `p_tipoDocumento` CHAR(5), IN `p_formaPago` CHAR(5), IN `p_idOficina` INT, IN `p_idTipoMoneda` INT, IN `p_idDestino` INT, IN `p_idUnidad` INT, IN `p_fechaEntrega` DATETIME, IN `p_fechaEmision` DATETIME, IN `p_registro_user_add` VARCHAR(50), IN `p_registro_user_update` VARCHAR(50), IN `p_tipoOperacion` INT)
BEGIN  
	DECLARE contadorInsert int;  
    DECLARE contadorUpdate int;
    DECLARE correlativoA   char(8);    
    
    DECLARE nProveedor int;
    DECLARE v_idProveedor int;
    DECLARE v_nombreProveedor varchar(300);
    DECLARE v_rucProveedor char(11);
    DECLARE v_direccionProveedor varchar(250);
    DECLARE v_telefonoProveedor varchar(12);
    DECLARE v_emailProveedor varchar(50);
    
    DECLARE subtotal	decimal(18,2);
    DECLARE descuento	decimal(18,2);
	DECLARE v_igv		decimal(18,2);
    DECLARE total		decimal(18,2);
    DECLARE v_id 		INT;
    DECLARE v_cor 		char(8);
    DECLARE v_cor_OC 		char(8);
    DECLARE v_bandera 	INT;
    
    DECLARE v_domicilioFiscal			VARCHAR(400);
    DECLARE v_tasaCambio	    		decimal(18,3);
    DECLARE v_idOrdenMantenimiento		INT;
    DECLARE v_idOrdenServicio			INT;
    
    IF p_tipoOperacion = 1 THEN
		-- IF EXISTS (SELECT idTasaCambio FROM TASA_CAMBIO WHERE fecha = CURDATE() ) THEN
			SET @v_igv = ( SELECT porcentaje FROM IGV WHERE anio = YEAR(NOW()) );
            SET @v_domicilioFiscal = ( SELECT domicilioFiscal FROM EMPRESA WHERE idEmpresa = 1 );
			
			INSERT INTO ORDEN_COMPRA(
				idCotizacion, idProveedor, nombreProveedor, rucProveedor, 
                direccionProveedor, telefonoProveedor, emailProveedor,
				correlativo, codCotizacion, tipoDocumento, formaPago, 
                idOficina, lugarAtencion, idTipoMoneda, tasaCambio,
				subTotal, descuento, igv, igv2, total,
				fechaEnvio, fechaEntrega, estadoEmision, estadoRecepcion,
				registro_fecha_add, registro_user_add, registro_pc_add, 
				registro_fecha_update, registro_user_update, registro_pc_update, activo
			)    
			VALUES (null, 0, '', '', 
					'','', '',
					'', '', '', '',
                    0, '', 1, 1.00,
					0.00, 0.00, @v_igv, 0.00,  0.00,
					now(), now(), 'A', 'SN', now(), p_registro_user_add, "-", 
					NULL, NULL, NULL, 1);			
			
			SELECT 1 as tipoRespuesta, 'Se registró correctamente.' as respuesta, idOrdenCompra 
            FROM ORDEN_COMPRA ORDER BY idOrdenCompra DESC LIMIT 1;
        -- ELSE
			-- SELECT  0 as tipoRespuesta, 'No se ha ingresado Tasa de Cambio el día de hoy.' as respuesta;
        -- END IF;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN
		IF (p_idTipoMoneda = 1 or 
				( p_idTipoMoneda != 1 and 
					EXISTS(SELECT idTasaCambio FROM TASA_CAMBIO WHERE fecha = p_fechaEmision and tipoMoneda = p_idTipoMoneda)    
				)
		   )  THEN 
			
            SET @v_tasaCambio = ifnull((SELECT precioVenta FROM TASA_CAMBIO WHERE FECHA = p_fechaEmision and tipoMoneda = p_idTipoMoneda limit 1), 1);
            
			SELECT nombreEmpresa, ruc, direccion, telefono1, email 
			INTO @v_nombreProveedor, @v_rucProveedor, @v_direccionProveedor, @v_telefonoProveedor, @v_emailProveedor
			FROM PROVEEDOR 
			WHERE idProveedor = p_idProveedor; 
        
			IF EXISTS (SELECT * FROM ORDEN_COMPRA WHERE idOrdenCompra = p_idOrdenCompra
								AND correlativo = '') THEN 
				SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM ORDEN_COMPRA WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
        
				SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
								END);   
                                
				SET @subTotal = (SELECT SUM(valorVenta) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
				SET @descuento = (SELECT SUM(descuentoTotal) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
				SET @total = (SELECT SUM(monto) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
            
				UPDATE `ORDEN_COMPRA` SET 
					idProveedor = p_idProveedor,
					nombreProveedor = @v_nombreProveedor,
					rucProveedor = @v_rucProveedor,
					direccionProveedor = @v_direccionProveedor,
					telefonoProveedor = @v_telefonoProveedor,
					emailProveedor = @v_emailProveedor,
					correlativo = @v_cor,
					codCotizacion = p_codCotizacion,
                    serieDocumento = p_serieDocumento,
                    numeroDocumento = p_numeroDocumento,
					tipoDocumento = p_tipoDocumento,
					formaPago = p_formaPago,
                    idOficina = p_idOficina,
                    lugarAtencion = (SELECT direccion FROM OFICINA WHERE idOficina = p_idOficina),
                    idTipoMoneda = p_idTipoMoneda,
                    idDestino = p_idDestino,
                    idUnidad = p_idUnidad,
                    tasaCambio = @v_tasaCambio, 
                    subtotal = @subtotal,
					descuento = @descuento,         
					igv2 = @total - @subtotal + @descuento,
                    total = @total,
					fechaEntrega = p_fechaEntrega,
					fechaEnvio = p_fechaEmision,
					estadoRecepcion = 'SE',
                    registro_fecha_update = now(),
					registro_user_update = p_registro_user_update, 
					registro_pc_update = '-'
				WHERE idOrdenCompra = p_idOrdenCompra;
                
				SELECT 1 AS 'tipoRespuesta', 
					CONCAT('Se guardó correctamente la Orden de Compra: OC-', @v_cor, '.') as respuesta;                   
			ELSE
            
				SET @subTotal = (SELECT SUM(valorVenta) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
				SET @descuento = (SELECT SUM(descuentoTotal) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
				SET @total = (SELECT SUM(monto) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
            
				UPDATE `ORDEN_COMPRA` SET 
					idProveedor = p_idProveedor,
					nombreProveedor = @v_nombreProveedor,
					rucProveedor = @v_rucProveedor,
					direccionProveedor = @v_direccionProveedor,
					telefonoProveedor = @v_telefonoProveedor,
					emailProveedor = @v_emailProveedor,
					codCotizacion = p_codCotizacion,
                    serieDocumento = p_serieDocumento,
                    numeroDocumento = p_numeroDocumento,
					tipoDocumento = p_tipoDocumento,
					formaPago = p_formaPago,
                    idOficina = p_idOficina,
                    lugarAtencion = (SELECT direccion FROM OFICINA WHERE idOficina = p_idOficina),
                    idTipoMoneda = p_idTipoMoneda,
                    idDestino = p_idDestino,
                    idUnidad = p_idUnidad,
                    tasaCambio = @v_tasaCambio, 
                    subtotal = @subtotal,
					descuento = @descuento,         
					igv2 = @total - @subtotal + @descuento,
                    total = @total,
					fechaEntrega = p_fechaEntrega,
					fechaEnvio = p_fechaEmision,
					estadoRecepcion = 'SE',
                    registro_fecha_update = now(),
					registro_user_update = p_registro_user_update, 
					registro_pc_update = '-'
				WHERE idOrdenCompra = p_idOrdenCompra;
                
                SELECT 1 AS 'tipoRespuesta', 
					CONCAT('Se actualizó correctamente la Orden de Compra.') as respuesta;            
			END IF;
		ELSE
			SELECT 0 AS 'tipoRespuesta', 
				CONCAT('No se ha registrado la tasa de cambio para esta fecha de emisión.') as respuesta;
        END IF;
	END IF;
    
	IF p_tipoOperacion = 3 THEN
		IF (p_idTipoMoneda = 1 or 
				( p_idTipoMoneda = 2 and 
					EXISTS(SELECT idTasaCambio FROM TASA_CAMBIO WHERE fecha = p_fechaEmision and tipoMoneda = p_idTipoMoneda)    
				)
		   )  THEN 
			
            SET @v_tasaCambio = ifnull((SELECT precioVenta FROM TASA_CAMBIO WHERE FECHA = p_fechaEmision and tipoMoneda = p_idTipoMoneda limit 1), 1);
            
			SELECT nombreEmpresa, ruc, direccion, telefono1, email 
			INTO @v_nombreProveedor, @v_rucProveedor, @v_direccionProveedor, @v_telefonoProveedor, @v_emailProveedor
			FROM PROVEEDOR 
			WHERE idProveedor = p_idProveedor; 
        
			IF EXISTS (SELECT * FROM ORDEN_COMPRA WHERE idOrdenCompra = p_idOrdenCompra
								AND correlativo = '') THEN 
				SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM ORDEN_COMPRA WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
        
				SET @v_cor_OC = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
								END);   
                                
				SET @subTotal = (SELECT SUM(valorVenta) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
				SET @descuento = (SELECT SUM(descuentoTotal) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
				SET @total = (SELECT SUM(monto) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
            
				UPDATE `ORDEN_COMPRA` SET 
					idProveedor = p_idProveedor,
					nombreProveedor = @v_nombreProveedor,
					rucProveedor = @v_rucProveedor,
					direccionProveedor = @v_direccionProveedor,
					telefonoProveedor = @v_telefonoProveedor,
					emailProveedor = @v_emailProveedor,
					correlativo = @v_cor_OC,
					codCotizacion = p_codCotizacion,
                    serieDocumento = p_serieDocumento,
                    numeroDocumento = p_numeroDocumento,
					tipoDocumento = p_tipoDocumento,
					formaPago = p_formaPago,
                    idOficina = p_idOficina,
                    lugarAtencion = (SELECT direccion FROM OFICINA WHERE idOficina = p_idOficina),
                    idTipoMoneda = p_idTipoMoneda,
                    idDestino = p_idDestino,
                    idUnidad = p_idUnidad,
                    tasaCambio = @v_tasaCambio, 
                    subtotal = @subtotal,
					descuento = @descuento,         
					igv2 = @total - @subtotal + @descuento,
                    total = @total,
					fechaEntrega = p_fechaEntrega,
					fechaEnvio = p_fechaEmision,
					estadoRecepcion = 'A',
                    registro_fecha_update = now(),
					registro_user_update = p_registro_user_update, 
					registro_pc_update = '-'
				WHERE idOrdenCompra = p_idOrdenCompra;
                
                SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM NOTA_ALMACEN WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
        
				SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
							END);
                
                INSERT INTO NOTA_ALMACEN (idAlmacen, idOrdenCompra, correlativo, tipoDocumento, serieDocumento, numeroDocumento,
					tipoOperacion, idTipoDocumento, subTotal, igv, igv2, total, fechaEmision, fechaContable, observaciones, tipoNota, estado,
					registro_fecha_add, registro_user_add, registro_pc_add, activo)
				SELECT 1, idOrdenCompra, @v_cor, tipoDocumento, serieDocumento, numeroDocumento,
					'02', '01', OC.subTotal, OC.igv, OC.igv2, OC.total, now(), now(), '', 'E', 'C',
                    now(), p_registro_user_update, '-', 1
                FROM ORDEN_COMPRA OC
                WHERE OC.idOrdenCompra = p_idOrdenCompra;
                
                INSERT INTO DETALLE_NOTA_ALMACEN (					
					idNotaAlmacen, idProducto, nombreProducto, idPresentacion, nombrePresentacion,
					valorPresentacion, precioPresentacion, 
					valorUnitario, precioUnitario, cantidad, 
					valorVenta, monto, 
					cantidadTotal, cantidadUsada, cantidadSaldo, 
					idUnidadMedida, unidadMedida, estado, 
					registro_fecha_add, registro_user_add, registro_pc_add, activo)
				SELECT LAST_INSERT_ID(), DOC.idProducto, DOC.nombreProducto, 					
					CASE WHEN DOC.idPresentacion = 0 THEN NULL ELSE DOC.idPresentacion END,  DOC.nombrePresentacion,
					DOC.valorUnitario * OC.tasaCambio,  DOC.precioUnitario * OC.tasaCambio,
					(CASE WHEN DOC.nombrePresentacion = '-' OR DOC.nombrePresentacion = '' THEN DOC.valorUnitario
						ELSE CAST(round(DOC.valorUnitario/ifnull(PR.cantidad, 1), 2) AS decimal(18,2))
					END) * OC.tasaCambio, 
					(CASE WHEN DOC.nombrePresentacion = '-' OR DOC.nombrePresentacion = '' THEN DOC.precioUnitario
						ELSE CAST(round(DOC.precioUnitario/ifnull(PR.cantidad, 1), 2) AS decimal(18,2))
					END) * OC.tasaCambio,
                    DOC.cantidad, 
					DOC.valorVenta * OC.tasaCambio, DOC.monto * OC.tasaCambio,
					DOC.cantidad* ifnull(PR.cantidad, 1), 0.00, DOC.cantidad * ifnull(PR.cantidad, 1),
                    M.abrev, M.descripcion, 'C',
                    now(), 'ADMIN', '-', 1
				FROM DETALLE_ORDEN DOC
                INNER JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = DOC.idOrdenCompra
                INNER JOIN PRODUCTO P ON P.idProducto = DOC.idProducto
                INNER JOIN MULTITABLA M ON M.abrev = P.unidad_medida
                LEFT JOIN PRESENTACION PR ON PR.idPresentacion = DOC.idPresentacion
				WHERE DOC.idOrdenCompra = p_idOrdenCompra;
                
                UPDATE PRODUCTO P, (
					SELECT DOC.idProducto,
						SUM(DOC.cantidad*ifnull(PR.cantidad, 1)) AS Cantidad
					FROM DETALLE_ORDEN DOC
					INNER JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = DOC.idOrdenCompra
					INNER JOIN PRODUCTO P ON P.idProducto = DOC.idProducto
					INNER JOIN MULTITABLA M ON M.abrev = P.unidad_medida
					LEFT JOIN PRESENTACION PR ON PR.idPresentacion = DOC.idPresentacion
					WHERE DOC.idOrdenCompra = p_idOrdenCompra AND DOC.activo = 1
                    GROUP BY DOC.idProducto
                ) DNA
                SET 
					P.StockActual = P.StockActual + DNA.Cantidad
                WHERE P.idProducto = DNA.idProducto;
                
                -- SELECT * FROM DETALLE_ORDEN;
                -- SELECT * FROM PRODUCTO;
                -- select * from multitabla where dep_id = 3;
				                    
				-- IF @v_emailProveedor = '' or @v_emailProveedor is null then
					-- SELECT 2 AS 'tipoRespuesta', 						
						-- CONCAT('Se cerró correctamente la Orden de Compra: OC-', @v_cor, '. Pero no se ha enviado por correo electrónico porque este Proveedor no cuenta con un correo registrado en el sistema.') as respuesta;
                -- ELSE
					SELECT 1 AS 'tipoRespuesta', 
						CONCAT('Se cerró correctamente la Orden de Compra: OC-', @v_cor_OC, '.' ) as respuesta;
				-- END IF;
			ELSE
            
				SET @subTotal = (SELECT SUM(valorVenta) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
				SET @descuento = (SELECT SUM(descuentoTotal) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
				SET @total = (SELECT SUM(monto) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
            
				UPDATE `ORDEN_COMPRA` SET 
					idProveedor = p_idProveedor,
					nombreProveedor = @v_nombreProveedor,
					rucProveedor = @v_rucProveedor,
					direccionProveedor = @v_direccionProveedor,
					telefonoProveedor = @v_telefonoProveedor,
					emailProveedor = @v_emailProveedor,
					codCotizacion = p_codCotizacion,
                    serieDocumento = p_serieDocumento,
                    numeroDocumento = p_numeroDocumento,
					tipoDocumento = p_tipoDocumento,
					formaPago = p_formaPago,
                    idOficina = p_idOficina,
                    lugarAtencion = (SELECT direccion FROM OFICINA WHERE idOficina = p_idOficina),
                    idTipoMoneda = p_idTipoMoneda,
                    idDestino = p_idDestino,
                    idUnidad = p_idUnidad,
                    tasaCambio = @v_tasaCambio, 
                    subtotal = @subtotal,
					descuento = @descuento,         
					igv2 = @total - @subtotal + @descuento,
                    total = @total,
					fechaEntrega = p_fechaEntrega,
					fechaEnvio = p_fechaEmision,
					estadoRecepcion = 'A',
                    registro_fecha_update = now(),
					registro_user_update = p_registro_user_update, 
					registro_pc_update = '-'
				WHERE idOrdenCompra = p_idOrdenCompra;
				
				SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM NOTA_ALMACEN WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
        
				SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
							END);
                
                INSERT INTO NOTA_ALMACEN (idAlmacen, idOrdenCompra, correlativo, tipoDocumento, serieDocumento, numeroDocumento,
					tipoOperacion, idTipoDocumento, subTotal, igv, igv2, total, fechaEmision, fechaContable, observaciones, tipoNota, estado,
					registro_fecha_add, registro_user_add, registro_pc_add, activo)
				SELECT 1, idOrdenCompra, @v_cor, tipoDocumento, serieDocumento, numeroDocumento,
					'02', '01', OC.subTotal, OC.igv, OC.igv2, OC.total, now(), now(), '', 'E', 'C',
                    now(), p_registro_user_update, '-', 1
                FROM ORDEN_COMPRA OC
                WHERE OC.idOrdenCompra = p_idOrdenCompra;
                
                INSERT INTO DETALLE_NOTA_ALMACEN (					
					idNotaAlmacen, idProducto, nombreProducto, idPresentacion, nombrePresentacion,
					valorPresentacion, precioPresentacion, 
					valorUnitario, precioUnitario, cantidad, 
					valorVenta, monto, 
					cantidadTotal, cantidadUsada, cantidadSaldo, 
					idUnidadMedida, unidadMedida, estado, 
					registro_fecha_add, registro_user_add, registro_pc_add, activo)
				SELECT LAST_INSERT_ID(), DOC.idProducto, DOC.nombreProducto, 					
					CASE WHEN DOC.idPresentacion = 0 THEN NULL ELSE DOC.idPresentacion END,  DOC.nombrePresentacion,
					DOC.valorUnitario * OC.tasaCambio,  DOC.precioUnitario * OC.tasaCambio,
					(CASE WHEN DOC.nombrePresentacion = '-' OR DOC.nombrePresentacion = '' THEN DOC.valorUnitario
						ELSE CAST(round(DOC.valorUnitario/ifnull(PR.cantidad, 1), 2) AS decimal(18,2))
					END) * OC.tasaCambio, 
					(CASE WHEN DOC.nombrePresentacion = '-' OR DOC.nombrePresentacion = '' THEN DOC.precioUnitario
						ELSE CAST(round(DOC.precioUnitario/ifnull(PR.cantidad, 1), 2) AS decimal(18,2))
					END) * OC.tasaCambio,
                    DOC.cantidad, 
					DOC.valorVenta * OC.tasaCambio, DOC.monto * OC.tasaCambio,
					DOC.cantidad * ifnull(PR.cantidad, 1), 0.00, DOC.cantidad * ifnull(PR.cantidad, 1),
                    M.abrev, M.descripcion, 'C',
                    now(), 'ADMIN', '-', 1
				FROM DETALLE_ORDEN DOC
                INNER JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = DOC.idOrdenCompra
                INNER JOIN PRODUCTO P ON P.idProducto = DOC.idProducto
                INNER JOIN MULTITABLA M ON M.abrev = P.unidad_medida
                LEFT JOIN PRESENTACION PR ON PR.idPresentacion = DOC.idPresentacion
				WHERE DOC.idOrdenCompra = p_idOrdenCompra;
                
                UPDATE PRODUCTO P, (
					SELECT DOC.idProducto,
						SUM(DOC.cantidad*ifnull(PR.cantidad, 1)) AS Cantidad
					FROM DETALLE_ORDEN DOC
					INNER JOIN ORDEN_COMPRA OC ON OC.idOrdenCompra = DOC.idOrdenCompra
					INNER JOIN PRODUCTO P ON P.idProducto = DOC.idProducto
					INNER JOIN MULTITABLA M ON M.abrev = P.unidad_medida
					LEFT JOIN PRESENTACION PR ON PR.idPresentacion = DOC.idPresentacion
					WHERE DOC.idOrdenCompra = p_idOrdenCompra AND DOC.activo = 1
                    GROUP BY DOC.idProducto
                ) DNA
                SET 
					P.StockActual = P.StockActual + DNA.Cantidad
                WHERE P.idProducto = DNA.idProducto;
                
				-- IF @v_emailProveedor = '' or @v_emailProveedor is null then
					-- SELECT 2 AS 'tipoRespuesta', 
						-- CONCAT('Se cerró correctamente la Orden de Compra. Pero no se ha enviado por correo electrónico porque este Proveedor no cuenta con un correo registrado en el sistema.') as respuesta;
                -- ELSE
					SELECT 1 AS 'tipoRespuesta', 
						CONCAT('Se cerró correctamente la Orden de Compra.') as respuesta;
				-- END IF;
			END IF;
		ELSE
			SELECT 0 AS 'tipoRespuesta', 
				CONCAT('No se ha registrado la tasa de cambio para esta fecha de emisión.') as respuesta;
        END IF;
	END IF;         
    
	IF p_tipoOperacion = 4 THEN
		DROP TEMPORARY TABLE IF EXISTS TEMPORAL;

		CREATE TEMPORARY TABLE TEMPORAL 		
        SELECT *
		FROM DETALLE_COTIZACION
		WHERE idCotizacion = p_idCotizacion
		ORDER BY idDetalleCotizacion ASC;
                        
        IF p_idTipoMoneda != 1 THEN
			IF EXISTS(SELECT idTasaCambio FROM TASA_CAMBIO 
						WHERE fecha = p_fechaEmision and tipoMoneda = p_idTipoMoneda) THEN
				SET @v_bandera = 2;
			ELSE
				SET @v_bandera = 0;
			END IF;
		ELSE 
			SET @v_bandera = 1;
        END IF;
		
        IF @v_bandera != 0 THEN
			SET @v_tasaCambio = ifnull((	SELECT precioVenta FROM TASA_CAMBIO WHERE FECHA = p_fechaEmision and tipoMoneda = p_idTipoMoneda ), 1);
            SET @v_domicilioFiscal = (SELECT direccion FROM OFICINA WHERE idOficina = p_idOficina);
			            
            SELECT idProveedor, idOrdenMantenimiento, idOrdenServicio
			INTO @v_idProveedor, @v_idOrdenMantenimiento, @v_idOrdenServicio
			FROM COTIZACION 
            WHERE idCotizacion = p_idCotizacion;
			
			
			SELECT nombreEmpresa, ruc, direccion, telefono1, email 
			INTO @v_nombreProveedor, @v_rucProveedor, @v_direccionProveedor, @v_telefonoProveedor, @v_emailProveedor
			FROM PROVEEDOR 
			WHERE idProveedor = @v_idProveedor;
            
			SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM ORDEN_COMPRA WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
			
			SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
							END);		
			
            SET @v_igv = (SELECT igv FROM COTIZACION WHERE idCotizacion = p_idCotizacion);
						
			INSERT INTO `ORDEN_COMPRA`(
				idCotizacion, idOrdenMantenimiento, idOrdenServicio,
				idProveedor, nombreProveedor, rucProveedor, direccionProveedor, telefonoProveedor, emailProveedor,
				correlativo, codCotizacion, serieDocumento, numeroDocumento, tipoDocumento, formaPago, 
                idOficina, lugarAtencion, idTipoMoneda, idDestino, idUnidad, tasaCambio,
				subTotal, descuento, igv, igv2, total,
				fechaEnvio, `fechaEntrega`, `estadoEmision`, estadoRecepcion,
				registro_fecha_add, registro_user_add, registro_pc_add, 
				registro_fecha_update, registro_user_update, registro_pc_update, activo
			)    
			VALUES (p_idCotizacion, @v_idOrdenMantenimiento, @v_idOrdenServicio,
				@v_idProveedor, @v_nombreProveedor, @v_rucProveedor, 
				@v_direccionProveedor,@v_telefonoProveedor, @v_emailProveedor,
				@v_cor, p_codCotizacion, p_serieDocumento, p_numeroDocumento, p_tipoDocumento, p_formaPago,
                p_idOficina, @v_domicilioFiscal, p_idTipoMoneda, p_idDestino, p_idUnidad, @v_tasaCambio,
				0.00, 0.00, @v_igv, 0.00, 0.00,
				p_fechaEmision, p_fechaEntrega, 'A', 'EN',
				now(), p_registro_user_add, "-", 
				now(), "-", "-", 1);
					
			SET @v_id = IFNULL( (SELECT idOrdenCompra FROM ORDEN_COMPRA ORDER BY idOrdenCompra DESC LIMIT 1),  1);
			
            INSERT INTO DETALLE_ORDEN(idOrdenCompra, 
				idProducto, nombreProducto, idPresentacion, nombrePresentacion,
				valorUnitario, valorUnitarioA, descuentoUnitario, descuentoUnitarioA, precioUnitario, precioUnitarioA, 
				cantidad, cantidadAceptada, cantidadRechazada, cantidadReenviada,
				valorVenta, valorVentaA, descuentoTotal, descuentoTotalA, `monto`, `montoA`,  
                cantidadTotal, cantidadTotalA, 
				idUnidadMedida, unidadMedida,
				estado, urgencia,
				registro_fecha_add, registro_user_add, registro_pc_add, 
				registro_fecha_update, registro_user_update, registro_pc_update, activo
			)         
			SELECT  @v_id, 
				idProducto, nombreProducto, idPresentacion, nombrePresentacion,
				valorUnitarioA, 0.00, descuentoUnitarioA, 0.00,  precioUnitarioA, 0.00,
				cantidadAceptada, 0, 0, 0, 
				valorVentaA, 0.00, descuentoTotalA, 0.00, montoA, 0.00, 
                cantidadTotalA, 0,
                idUnidadMedida, unidadMedida,
				'EN', urgencia,  
				now(), p_registro_user_add, "-", now(), "-", "-", 1
			FROM TEMPORAL;
                       
		
			SET @total = (SELECT SUM(monto) FROM DETALLE_ORDEN WHERE idOrdenCompra = @v_id);
            SET @descuento = (SELECT SUM(descuentoTotal) FROM DETALLE_ORDEN WHERE idOrdenCompra = @v_id);
			SET @subtotal = (SELECT SUM(valorVenta) FROM DETALLE_ORDEN WHERE idOrdenCompra = @v_id);
			SET @v_igv = @total - @subtotal + @descuento;
            
			UPDATE ORDEN_COMPRA SET 
				total = @total,
				descuento = @descuento,
				igv2 = @v_igv,
                subtotal = @subtotal
            WHERE idOrdenCompra = @v_id;
        
			UPDATE COTIZACION SET 
				codCotizacion = p_codCotizacion,
				fechaAceptada = now(),
				estado = 'A'
			WHERE idCotizacion = p_idCotizacion;
			
            IF @v_emailProveedor = '' or @v_emailProveedor is null then
				SELECT 2 AS 'tipoRespuesta', 
						CONCAT('Se registró correctamente la Orden de Compra: OC-', @v_cor, ' . Pero no se ha enviado por correo electrónico porque este Proveedor no cuenta con un correo registrado en el sistema.') as respuesta,
						@v_id as 'idOrdenCompra';
            ELSE
				SELECT 1 AS 'tipoRespuesta', 
						CONCAT('Se generó correctamente la Orden de Compra: OC-', @v_cor) AS 'respuesta', 
                        @v_id as 'idOrdenCompra';
			END IF;
		ELSE
			SELECT 0 as tipoRespuesta, 'No se ha ingresado la Tasa de Cambio para la fecha de emisión.' as respuesta;
		END IF;
    END	IF; 
    
    IF p_tipoOperacion = 5 THEN
		UPDATE `DETALLE_ORDEN` SET						
						`precioUnitarioA` = 0.00,                        
						`cantidadAceptada` = 0,
						`cantidadReenviada` = 0,
						`cantidadRechazada` = 0,
                        `montoA` = 0.00, 
                        `cantidadTotalA` = 0,
                        `estado` = 'EN',
						`registro_fecha_update` = now(),
						`registro_user_update` = p_registro_user_update, 
						`registro_pc_update` = '-'
		WHERE idDetalleOrden = p_idDetalleOrden;	
        
        SET @contadorUpdate = (SELECT COUNT(idDetalleOrden) FROM DETALLE_ORDEN WHERE
									idOrdenCompra = p_idOrdenCompra AND estado != 'C');
		
        UPDATE ORDEN_COMPRA SET 
            estado = (CASE WHEN @contadorUpdate > 0 then 'P'
											  END)
		WHERE idOrdenCompra = p_idOrdenCompra;
        
		SELECT 1 AS 'respuesta';
	END IF;
    
    IF p_tipoOperacion = 6 THEN
        IF (p_idTipoMoneda = 1 or 
				( p_idTipoMoneda = 2 and 
					EXISTS(SELECT idTasaCambio FROM TASA_CAMBIO WHERE fecha = p_fechaEmision and tipoMoneda = p_idTipoMoneda)    
				)
		   )  THEN 
			
            SET @v_tasaCambio = ifnull((SELECT precioVenta FROM TASA_CAMBIO WHERE FECHA = p_fechaEmision and tipoMoneda = p_idTipoMoneda limit 1), 1);
            
			SELECT nombreEmpresa, ruc, direccion, telefono1, email 
			INTO @v_nombreProveedor, @v_rucProveedor, @v_direccionProveedor, @v_telefonoProveedor, @v_emailProveedor
			FROM PROVEEDOR 
			WHERE idProveedor = p_idProveedor; 
        
			IF EXISTS (SELECT * FROM ORDEN_COMPRA WHERE idOrdenCompra = p_idOrdenCompra
								AND correlativo = '') THEN 
				SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM ORDEN_COMPRA WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
        
				SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
									WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
								END);   
                                
				SET @subTotal = (SELECT SUM(valorVenta) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
				SET @descuento = (SELECT SUM(descuentoTotal) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
				SET @total = (SELECT SUM(monto) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
            
				UPDATE `ORDEN_COMPRA` SET 
					idProveedor = p_idProveedor,
					nombreProveedor = @v_nombreProveedor,
					rucProveedor = @v_rucProveedor,
					direccionProveedor = @v_direccionProveedor,
					telefonoProveedor = @v_telefonoProveedor,
					emailProveedor = @v_emailProveedor,
					correlativo = @v_cor,
					codCotizacion = p_codCotizacion,
                    serieDocumento = p_serieDocumento,
                    numeroDocumento = p_numeroDocumento,
					tipoDocumento = p_tipoDocumento,
					formaPago = p_formaPago,
                    idOficina = p_idOficina,
                    lugarAtencion = (SELECT direccion FROM OFICINA WHERE idOficina = p_idOficina),
                    idTipoMoneda = p_idTipoMoneda,
                    idDestino = p_idDestino,
                    idUnidad = p_idUnidad,
                    tasaCambio = @v_tasaCambio, 
                    subtotal = @subtotal,
					descuento = @descuento,         
					igv2 = @total - @subtotal + @descuento,
                    total = @total,
					fechaEntrega = p_fechaEntrega,
					fechaEnvio = p_fechaEmision,
					estadoRecepcion = 'EN',
					registro_user_update = p_registro_user_update, 
                    registro_fecha_update = now(),
					registro_pc_update = '-'
				WHERE idOrdenCompra = p_idOrdenCompra;
                
                UPDATE DETALLE_ORDEN 
                SET 
					-- valorUnitarioA = valorUnitario,
                    -- descuentoUnitarioA = descuentoUnitario,
                    -- precioUnitarioA = precioUnitario, cantidadAceptada = cantidad,
                    -- valorVentaA = valorVenta,
                    -- descuentoTotalA = descuentoTotal,
					-- montoA = monto, cantidadTotalA = cantidadTotal, 
					estado = 'EN',
					registro_user_update = p_registro_user_update, 
                    registro_fecha_update = now(),
					registro_pc_update = '-'
				WHERE idOrdenCompra = p_idOrdenCompra;
                
				SELECT 1 AS 'tipoRespuesta', 
					CONCAT('Se guardó correctamente la Orden de Compra: OC-', @v_cor, '.') as respuesta,
                    p_idOrdenCompra as 'idOrdenCompra';                   
			ELSE
            
				SET @subTotal = (SELECT SUM(valorVenta) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
				SET @descuento = (SELECT SUM(descuentoTotal) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
				SET @total = (SELECT SUM(monto) FROM DETALLE_ORDEN WHERE idOrdenCompra = p_idOrdenCompra);
            
				UPDATE `ORDEN_COMPRA` SET 
					idProveedor = p_idProveedor,
					nombreProveedor = @v_nombreProveedor,
					rucProveedor = @v_rucProveedor,
					direccionProveedor = @v_direccionProveedor,
					telefonoProveedor = @v_telefonoProveedor,
					emailProveedor = @v_emailProveedor,
					codCotizacion = p_codCotizacion,
                    serieDocumento = p_serieDocumento,
                    numeroDocumento = p_numeroDocumento,
					tipoDocumento = p_tipoDocumento,
					formaPago = p_formaPago,
                    idOficina = p_idOficina,
                    lugarAtencion = (SELECT direccion FROM OFICINA WHERE idOficina = p_idOficina),
                    idTipoMoneda = p_idTipoMoneda,
                    idDestino = p_idDestino,
                    idUnidad = p_idUnidad,
                    tasaCambio = @v_tasaCambio, 
                    subtotal = @subtotal,
					descuento = @descuento,         
					igv2 = @total - @subtotal + @descuento,
                    total = @total,
					fechaEntrega = p_fechaEntrega,
					fechaEnvio = p_fechaEmision,
					estadoRecepcion = 'EN',
                    registro_fecha_update = now(),
					registro_user_update = p_registro_user_update, 
					registro_pc_update = '-'
				WHERE idOrdenCompra = p_idOrdenCompra;
                
                UPDATE DETALLE_ORDEN SET 
					-- valorUnitarioA = valorUnitario,
                    -- descuentoUnitarioA = descuentoUnitario,
					-- precioUnitarioA = precioUnitario, cantidadAceptada = cantidad,
                    -- valorVentaA = valorVenta,
                    -- descuentoTotalA = descuentoTotal,
					-- montoA = monto, cantidadTotalA = cantidadTotal, 
                    estado = 'EN',
                    registro_fecha_update = now(),
					registro_user_update = p_registro_user_update, 
					registro_pc_update = '-'
				WHERE idOrdenCompra = p_idOrdenCompra;
            
                SELECT 1 AS 'tipoRespuesta', 
					CONCAT('Se actualizó correctamente la Orden de Compra.') as respuesta,
                    p_idOrdenCompra as idOrdenCompra; 
			END IF;
		ELSE
			SELECT 0 AS 'tipoRespuesta', 
				CONCAT('No se ha registrado la tasa de cambio para esta fecha de emisión.') as respuesta,
                p_idOrdenCompra as idOrdenCompra;
        END IF;
	END IF; 
    
    IF p_tipoOperacion = 7 THEN
		DROP TEMPORARY TABLE IF EXISTS TEMPORAL;

		CREATE TEMPORARY TABLE TEMPORAL 		
        SELECT *
		FROM DETALLE_COTIZACION
		WHERE idCotizacion = p_idCotizacion
		ORDER BY idDetalleCotizacion ASC;
        
        IF p_idTipoMoneda != 1 THEN
			IF EXISTS(SELECT idTasaCambio FROM TASA_CAMBIO 
						WHERE fecha = p_fechaEmision and tipoMoneda = p_idTipoMoneda) THEN
				SET @v_bandera = 2;
			ELSE
				SET @v_bandera = 0;
			END IF;
		ELSE 
			SET @v_bandera = 1;
        END IF;
		
        IF @v_bandera != 0 THEN
            SET @v_tasaCambio = ifnull((	SELECT precioVenta FROM TASA_CAMBIO WHERE FECHA = p_fechaEmision and tipoMoneda = p_idTipoMoneda), 1);
			SET @v_domicilioFiscal = (SELECT direccion FROM OFICINA WHERE idOficina = p_idOficina);
            
            SELECT idProveedor, idOrdenMantenimiento, idOrdenServicio
			INTO @v_idProveedor, @v_idOrdenMantenimiento, @v_idOrdenServicio
			FROM COTIZACION 
            WHERE idCotizacion = p_idCotizacion;
			
			SELECT nombreEmpresa, ruc, direccion, telefono1, email 
			INTO @v_nombreProveedor, @v_rucProveedor, @v_direccionProveedor, @v_telefonoProveedor, @v_emailProveedor
			FROM PROVEEDOR 
			WHERE idProveedor = @v_idProveedor;
						
			SET @v_igv = (SELECT igv FROM COTIZACION WHERE idCotizacion = p_idCotizacion);
            
			SET @v_id = IFNULL((SELECT cast(correlativo as unsigned) FROM ORDEN_COMPRA WHERE correlativo is not null ORDER BY correlativo desc limit 1), 0);
			
			SET @v_cor = (CASE WHEN (cast(@v_id as UNSIGNED)  + 1) < 10 THEN CONCAT('00000', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 100 THEN CONCAT('0000', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000 THEN CONCAT('000', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 10000 THEN CONCAT('00', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 100000 THEN CONCAT('0', (CAST(@v_id as UNSIGNED) + 1) )
								WHEN (cast(@v_id as UNSIGNED)  + 1) < 1000000 THEN  (CAST(@v_id as UNSIGNED) + 1)
							END);
							
								  
            INSERT INTO `ORDEN_COMPRA`(
				idCotizacion, idOrdenMantenimiento, idOrdenServicio,
				idProveedor, nombreProveedor, rucProveedor, direccionProveedor, telefonoProveedor, emailProveedor,
				correlativo, codCotizacion, serieDocumento, numeroDocumento, tipoDocumento, formaPago, 
                idOficina, lugarAtencion, idTipoMoneda, idDestino, idUnidad, tasaCambio,
				subTotal, descuento, igv, igv2, total,
				fechaEnvio, `fechaEntrega`, `estadoEmision`, estadoRecepcion,
				registro_fecha_add, registro_user_add, registro_pc_add, 
				registro_fecha_update, registro_user_update, registro_pc_update, activo
			)  
			VALUES (p_idCotizacion, @v_idOrdenMantenimiento, @v_idOrdenServicio,
				@v_idProveedor, @v_nombreProveedor, @v_rucProveedor, @v_direccionProveedor,@v_telefonoProveedor, @v_emailProveedor,
				@v_cor, p_codCotizacion, p_serieDocumento, p_numeroDocumento, p_tipoDocumento, p_formaPago,
                p_idOficina, @v_domicilioFiscal, p_idTipoMoneda, p_idDestino, p_idUnidad, @v_tasaCambio,
				0.00, 0.00, @v_igv, 0.00,0.00,
				p_fechaEmision, p_fechaEntrega, 'A', 'A',
				now(), p_registro_user_add, "-", 
				now(), "-", "-", 1);
					
			SET @v_id = IFNULL((SELECT idOrdenCompra FROM ORDEN_COMPRA ORDER BY idOrdenCompra DESC LIMIT 1), 1);
            
			INSERT INTO `DETALLE_ORDEN`(idOrdenCompra, 
				idProducto, nombreProducto, idPresentacion, nombrePresentacion,
				valorUnitario, valorUnitarioA, descuentoUnitario, descuentoUnitarioA, precioUnitario, precioUnitarioA, 
				cantidad, cantidadAceptada, cantidadRechazada, cantidadReenviada,
				valorVenta, valorVentaA, descuentoTotal, descuentoTotalA, `monto`, `montoA`,  
                cantidadTotal, cantidadTotalA, 
				idUnidadMedida, unidadMedida,
				estado, urgencia,
				registro_fecha_add, registro_user_add, registro_pc_add, 
				registro_fecha_update, registro_user_update, registro_pc_update, activo
			)         
			SELECT  @v_id, 
				idProducto, nombreProducto, idPresentacion, nombrePresentacion,
				valorUnitarioA, valorUnitarioA, descuentoUnitarioA, descuentoUnitarioA,  precioUnitarioA, precioUnitarioA,
				cantidadAceptada, cantidadAceptada, 0, 0, 
				valorVentaA, valorVentaA, descuentoTotalA, descuentoTotalA, montoA, montoA, 
                cantidadTotalA, cantidadTotalA,
                idUnidadMedida, unidadMedida,
				'EN', urgencia,  
				now(), p_registro_user_add, "-", now(), "-", "-", 1
			FROM TEMPORAL;   				
		    
			SET @total = (SELECT SUM(monto) FROM DETALLE_ORDEN WHERE idOrdenCompra = @v_id);
            SET @descuento = (SELECT SUM(descuentoTotal) FROM DETALLE_ORDEN WHERE idOrdenCompra = @v_id);
			SET @subtotal = (SELECT SUM(valorVenta) FROM DETALLE_ORDEN WHERE idOrdenCompra = @v_id);
			SET @v_igv = @total - @subtotal + @descuento;
            
			UPDATE ORDEN_COMPRA SET 
                subtotal = @subtotal,
                descuento = @descuento,
				igv2 = @v_igv,
				total = @total
            WHERE idOrdenCompra = @v_id;
        
			UPDATE COTIZACION SET 
				codCotizacion = p_codCotizacion,
				fechaAceptada = now(),
				estado = 'A'
			WHERE idCotizacion = p_idCotizacion;
			
            SELECT 1 as tipoRespuesta,  CONCAT('OC-', @v_cor) AS 'respuesta', @v_id as 'idOrdenCompra';
		ELSE
			SELECT 0 as tipoRespuesta, 'No se ha ingresado la Tasa de Cambio para la fecha de emisión.' as respuesta;
		END IF;
    END	IF; 
    
    IF p_tipoOperacion = 8 THEN
		IF EXISTS(SELECT idCompra FROM COMPRA WHERE idOrdenCompra = p_idOrdenCompra)  THEN
			SELECT 0 as tipoRespuesta, 'Esta Orden de Compra ya tiene una Compra generada.' as respuesta;
        ELSE	
			UPDATE `ORDEN_COMPRA` SET 
				codCotizacion = p_codCotizacion,
                serieDocumento = p_serieDocumento,
                numeroDocumento = p_numeroDocumento,
                tipoDocumento = p_tipoDocumento,
                formaPago = p_formaPago,
                idOficina = p_idOficina,
                lugarAtencion = (SELECT direccion FROM OFICINA WHERE idOficina = p_idOficina),
                idTipoMoneda = p_idTipoMoneda,
                idDestino = p_idDestino,
                idUnidad = p_idUnidad,
                tasaCambio = ifnull((SELECT precioVenta FROM TASA_CAMBIO WHERE fecha = p_fechaEmision and tipoMoneda = idTipoMoneda limit 1), 1),
				estadoRecepcion = 'AN',
				`registro_fecha_update` = now(), `registro_user_update` = p_registro_user_update, 
				`registro_pc_update` = '-'
			WHERE idOrdenCompra = p_idOrdenCompra;	            
			           
			SELECT 1 AS tipoRespuesta, 'Se anuló correctamente.' AS 'respuesta';
		END IF;
	END IF;
    
    IF p_tipoOperacion = 9 THEN
		IF EXISTS (SELECT idTasaCambio FROM TASA_CAMBIO WHERE fecha = CURDATE() ) THEN
		
			SET @v_igv = ( SELECT porcentaje FROM IGV WHERE anio = YEAR(NOW()) );
            SET @v_domicilioFiscal = ( SELECT domicilioFiscal FROM EMPRESA WHERE idEmpresa = 1 );
			
			INSERT INTO `ORDEN_COMPRA`(
				idCotizacion, idOrdenMantenimiento, idProveedor, nombreProveedor, rucProveedor, 
				direccionProveedor, telefonoProveedor, emailProveedor,
				correlativo, codCotizacion, tipoDocumento, formaPago, 
                idOficina, lugarAtencion, idTipoMoneda, tasaCambio,
				subTotal, descuento, igv, igv2, total,
				fechaEnvio, fechaEntrega, estadoEmision, estadoRecepcion,
				registro_fecha_add, registro_user_add, registro_pc_add, 
				registro_fecha_update, registro_user_update, registro_pc_update, activo
			)    
			VALUES (null, p_idOrdenMantenimiento, 0, '', '', 
					'','', '',
					'', '', '', '',
                    0, '', 1, 1.00,
					0.00, 0.00, @v_igv, 0.00,  0.00,
					now(), now(), 'A', 'SN',   					
                    now(), p_registro_user_add, "-", 
					now(), "-", "-", 1);     
			
						SET @v_id = IFNULL( (SELECT idOrdenCompra FROM ORDEN_COMPRA ORDER BY idOrdenCompra DESC LIMIT 1), 1);            
            
			INSERT INTO DETALLE_ORDEN(idOrdenCompra, 
				idProducto, nombreProducto, idPresentacion, nombrePresentacion,
                valorUnitario, valorUnitarioA,
                descuentoUnitario, descuentoUnitarioA,
				precioUnitario, precioUnitarioA, 
				cantidad, cantidadAceptada, cantidadRechazada, cantidadReenviada,
				valorVenta, valorVentaA,
                descuentoTotal, descuentoTotalA,
                monto, montoA, cantidadTotal, cantidadTotalA, 
				idUnidadMedida, unidadMedida,
				estado, urgencia,
				registro_fecha_add, registro_user_add, registro_pc_add, 
				registro_fecha_update, registro_user_update, registro_pc_update, activo
			)         
			SELECT @v_id as idOrdenCompra, 
				DOM.idProducto, P.nombre as nombreProducto, 
				PR.idPresentacion as idPresentacion, PR.nombre as nombrePresentacion,
                0.00 as valorUnitario, 0.00 as valorUnitarioA,
                0.00 as descuentoUnitario, 0.00 as descuentoUnitarioA,
				0.00 as precioUnitario, 0.00 as precioUnitarioA, 
				sum(DOM.cantidad) as cantidad, 0.00, 0.00, 0.00,
				0.00 as valorVenta, 0.00 as valorVentaA, 
				0.00 as descuentoTotal, 0.00 as descuentoTotalA, 
				0.00 as monto, 0.00 as montoA, 
                sum(DOM.cantidad) as cantidadTotal, 0.00,
				P.unidad_medida, M.descripcion, 'EN', 'B' as urgencia,
				now(), p_registro_user_add, '-',
				now(), p_registro_user_update, '-', 1
			FROM DETALLE_ORDEN_MANTENIMIENTO DOM
			INNER JOIN PRODUCTO P ON DOM.idProducto = P.idProducto
			INNER JOIN PRESENTACION PR ON PR.idProducto = P.idProducto and PR.nombre = '-'
			INNER JOIN MULTITABLA M ON M.abrev = P.unidad_medida and M.dep_id = 3
			WHERE DOM.idOrdenMantenimiento = p_idOrdenMantenimiento and DOM.estado = 'A'
			GROUP BY DOM.idProducto;
			
			            SELECT 1 as tipoRespuesta, 'Se registró correctamente.' as respuesta, idOrdenCompra 
            FROM ORDEN_COMPRA ORDER BY idOrdenCompra DESC LIMIT 1;
        ELSE
			SELECT  0 as tipoRespuesta, 'No se ha ingresado Tasa de Cambio el día de hoy.' as respuesta;
        END IF;
    END	IF;
    
    IF p_tipoOperacion = 10 THEN
		IF EXISTS (SELECT idTasaCambio FROM TASA_CAMBIO WHERE fecha = CURDATE() ) THEN
		
			SET @v_igv = ( SELECT porcentaje FROM IGV WHERE anio = YEAR(NOW()) );
            SET @v_domicilioFiscal = ( SELECT domicilioFiscal FROM EMPRESA WHERE idEmpresa = 1 );
			
			INSERT INTO `ORDEN_COMPRA`(
				idCotizacion, idOrdenServicio, idProveedor, nombreProveedor, rucProveedor, 
				direccionProveedor, telefonoProveedor, emailProveedor,
				correlativo, codCotizacion, tipoDocumento, formaPago, 
                idOficina, lugarAtencion, idTipoMoneda, tasaCambio,
				subTotal, descuento, igv, igv2, total,
				fechaEnvio, fechaEntrega, estadoEmision, estadoRecepcion,
				registro_fecha_add, registro_user_add, registro_pc_add, 
				registro_fecha_update, registro_user_update, registro_pc_update, activo
			)
			VALUES (null, p_idOrdenServicio, 0, '', '', 
					'','', '',
					'', '', '', '',
                    0, '', 1, 1.00,
					0.00, 0.00, @v_igv, 0.00,  0.00,
					now(), now(), 'A', 'SN',   					now(), p_registro_user_add, "-", 
					now(), "-", "-", 1); 
			
			SET @v_id = IFNULL((SELECT idOrdenCompra FROM ORDEN_COMPRA ORDER BY idOrdenCompra DESC LIMIT 1), 1);
            
            INSERT INTO DETALLE_ORDEN(idOrdenCompra, 
				idProducto, nombreProducto, idPresentacion, nombrePresentacion,
                valorUnitario, valorUnitarioA,
                descuentoUnitario, descuentoUnitarioA,
				precioUnitario, precioUnitarioA, 
				cantidad, cantidadAceptada, cantidadRechazada, cantidadReenviada,
				valorVenta, valorVentaA,
                descuentoTotal, descuentoTotalA,
                monto, montoA, cantidadTotal, cantidadTotalA, 
				idUnidadMedida, unidadMedida,
				estado, urgencia,
				registro_fecha_add, registro_user_add, registro_pc_add, 
				registro_fecha_update, registro_user_update, registro_pc_update, activo
			)       
			SELECT @v_id as idOrdenCompra, 
				DOS.idProducto, P.nombre as nombreProducto,
				PR.idPresentacion as idPresentacion, PR.nombre as nombrePresentacion,
                0.00 as valorUnitario, 0.00 as valorUnitarioA,
                0.00 as descuentoUnitario, 0.00 as descuentoUnitarioA,
				0.00 as precioUnitario, 0.00 as precioUnitarioA, 
				sum(DOS.cantidad) as cantidad, 0.00, 0.00, 0.00,
				0.00 as valorVenta, 0.00 as valorVentaA,
				0.00 as descuentoTotal, 0.00 as descuentoTotalA,
				0.00 as monto, 0.00 as montoA, 
                sum(DOS.cantidad) as cantidadTotal, 0.00,
				P.unidad_medida, M.descripcion, 'EN', 'B' as urgencia,
				now(), p_registro_user_add, '-',
				now(), p_registro_user_update, '-', 1
			FROM DETALLE_ORDEN_SERVICIO DOS
			INNER JOIN PRODUCTO P ON DOS.idProducto = P.idProducto
			INNER JOIN PRESENTACION PR ON PR.idProducto = P.idProducto and PR.nombre = '-'
			INNER JOIN MULTITABLA M ON M.abrev = P.unidad_medida and M.dep_id = 3
			WHERE DOS.idOrdenServicio = p_idCotizacion and DOS.estado = 'A'
			GROUP BY DOS.idProducto;
			
			            SELECT 1 as tipoRespuesta, 'Se registró correctamente.' as respuesta, idOrdenCompra 
            FROM ORDEN_COMPRA ORDER BY idOrdenCompra DESC LIMIT 1;
        ELSE
			SELECT  0 as tipoRespuesta, 'No se ha ingresado Tasa de Cambio el día de hoy.' as respuesta;
        END IF;
    END	IF;
    
    IF p_tipoOperacion = 11 THEN
		IF EXISTS (SELECT idTasaCambio FROM TASA_CAMBIO WHERE fecha = CURDATE() ) THEN
		
			SET @v_igv = ( SELECT porcentaje FROM IGV WHERE anio = YEAR(NOW()) );
            SET @v_domicilioFiscal = ( SELECT domicilioFiscal FROM EMPRESA WHERE idEmpresa = 1 );
			
			INSERT INTO `ORDEN_COMPRA`(
				idCotizacion, idOrdenServicio, idProveedor, nombreProveedor, rucProveedor, 
				direccionProveedor, telefonoProveedor, emailProveedor,
				correlativo, codCotizacion, tipoDocumento, formaPago, 
                idOficina, lugarAtencion, idTipoMoneda, tasaCambio,
				subTotal, descuento, igv, igv2, total,
				fechaEnvio, fechaEntrega, estadoEmision, estadoRecepcion,
				registro_fecha_add, registro_user_add, registro_pc_add, 
				registro_fecha_update, registro_user_update, registro_pc_update, activo
			)
			VALUES (null, null, 0, '', '', 
					'','', '',
					'', '', '', '',
                    0, '', 1, 1.00,
					0.00, 0.00, @v_igv, 0.00,  0.00,
					now(), now(), 'A', 'SN',   					now(), p_registro_user_add, "-", 
					now(), "-", "-", 1); 
			
						SET @v_id = IFNULL((SELECT idOrdenCompra FROM ORDEN_COMPRA ORDER BY idOrdenCompra DESC LIMIT 1), 1);
            
            INSERT INTO DETALLE_ORDEN(idOrdenCompra, 
				idProducto, nombreProducto, idPresentacion, nombrePresentacion,
                valorUnitario, valorUnitarioA,
                descuentoUnitario, descuentoUnitarioA,
				precioUnitario, precioUnitarioA, 
				cantidad, cantidadAceptada, cantidadRechazada, cantidadReenviada,
				valorVenta, valorVentaA,
                descuentoTotal, descuentoTotalA,
                monto, montoA, cantidadTotal, cantidadTotalA, 
				idUnidadMedida, unidadMedida,
				estado, urgencia,
				registro_fecha_add, registro_user_add, registro_pc_add, 
				registro_fecha_update, registro_user_update, registro_pc_update, activo
			)       
			SELECT @v_id as idOrdenCompra, 
				DNA.idProducto, P.nombre as nombreProducto,
				PR.idPresentacion as idPresentacion, PR.nombre as nombrePresentacion,
                0.00 as valorUnitario, 0.00 as valorUnitarioA,
                0.00 as descuentoUnitario, 0.00 as descuentoUnitarioA,
				0.00 as precioUnitario, 0.00 as precioUnitarioA, 
				sum(DNA.cantidad) as cantidad, 0.00, 0.00, 0.00,
				0.00 as valorVenta, 0.00 as valorVentaA,
				0.00 as descuentoTotal, 0.00 as descuentoTotalA,
				0.00 as monto, 0.00 as montoA, 
                sum(DNA.cantidad) as cantidadTotal, 0.00,
				P.unidad_medida, M.descripcion, 'EN', 'B' as urgencia,
				now(), p_registro_user_add, '-',
				now(), p_registro_user_update, '-', 1
			FROM DETALLE_NOTA_ALMACEN DNA
			INNER JOIN PRODUCTO P ON DNA.idProducto = P.idProducto
			INNER JOIN PRESENTACION PR ON PR.idProducto = P.idProducto and PR.nombre = '-'
			INNER JOIN MULTITABLA M ON M.abrev = P.unidad_medida and M.dep_id = 3
			WHERE DNA.idNotaAlmacen = p_idCotizacion and DNA.estado = 'PC'
			GROUP BY DNA.idProducto;
			
			            SELECT 1 as tipoRespuesta, 'Se registró correctamente.' as respuesta, idOrdenCompra 
            FROM ORDEN_COMPRA ORDER BY idOrdenCompra DESC LIMIT 1;
        ELSE
			SELECT  0 as tipoRespuesta, 'No se ha ingresado Tasa de Cambio el día de hoy.' as respuesta;
        END IF;
    END	IF;
END
$